<?php
/**
 * @package   mod_adsimple_acm
 * @copyright Copyright (C) 2025 AdSimple GmbH. All rights reserved.
 * @license   GNU General Public License version 2, or later
 * 
 * Entry point for the AdSimple ACM (Consent Manager) module.
 *
 * This file initializes the module environment, prepares variables,
 * and loads the appropriate layout file for rendering on the frontend.
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Form\FormHelper;

// Compatibility for Joomla 6+
// Joomla\CMS\Filesystem\File and Folder moved to Joomla\Filesystem namespace.
$version = (new \Joomla\CMS\Version())->getShortVersion();
$major   = (int) explode('.', $version)[0];
if ($major >= 6) {
	if (!class_exists('Joomla\\CMS\\Filesystem\\File') && class_exists('Joomla\\Filesystem\\File')) {
		class_alias('Joomla\\Filesystem\\File', 'Joomla\\CMS\\Filesystem\\File');
	}
	if (!class_exists('Joomla\\CMS\\Filesystem\\Folder') && class_exists('Joomla\\Filesystem\\Folder')) {
		class_alias('Joomla\\Filesystem\\Folder', 'Joomla\\CMS\\Filesystem\\Folder');
	}
}

// -------------------------------------------------------------------------
// Prepare module parameters and environment
// -------------------------------------------------------------------------

// Retrieve optional CSS class suffix for custom styling
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8');

// -------------------------------------------------------------------------
// Load layout only if module is enabled
// -------------------------------------------------------------------------
if ($params->get('enabled', 1)) {
    // Include the layout file (default: tmpl/default.php)
    require ModuleHelper::getLayoutPath('mod_adsimple_acm', $params->get('layout', 'default'));
}
