<?php
/**
 * @package   mod_adsimple_acm
 * @copyright Copyright (C) 2025 AdSimple GmbH. All rights reserved.
 * @license   GNU General Public License version 2, or later
 */
defined('_JEXEC') or die;

use Joomla\CMS\Form\FormRule;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory; // We need this use statement
require_once JPATH_SITE . '/modules/mod_adsimple_acm/helper.php';

/**
 * Form Rule class for simple validation.
 */
class JFormRuleAdsimpleid extends FormRule
{
    /**
     * Method to test the field value.
     *
     * @param   \SimpleXMLElement  $element  The SimpleXMLElement object for the form field.
     * @param   mixed              $value    The form field value.
     * @param   string             $group    The field name group.
     * @param   Registry           $input    An optional Registry object of the entire form data.
     * @param   \Joomla\CMS\Form\Form  $form     An optional Form object.
     *
     * @return  bool|string  True if the value is valid, string of error message otherwise.
     *
     * @since   4.0.0
     */
    public function test(\SimpleXMLElement $element, $value, $group = null, Registry $input = null, \Joomla\CMS\Form\Form $form = null)
    {
        $value = trim($value); // Clean up the input

        $isValid = ModAdsimpleAcmHelper::validateAdsimpleId($value);

        $app = Factory::getApplication(); // Get the application instance

        if ($isValid === false) {
            // Return an error message if the helper says it's invalid
            return false; // Return false to indicate failure
        }
        
    

        // If all checks pass, return true
        return true;
    }
}