<?php
/**
 * @package   mod_adsimple_acm
 * @copyright Copyright (C) 2025 AdSimple GmbH. All rights reserved.
 * @license   GNU General Public License version 2, or later
 *
 * Updated version with reliable caching and HTTP fallback.
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Version;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Uri\Uri;
require_once JPATH_SITE . '/modules/mod_adsimple_acm/helper.php';
if (!defined('ADSIMPLE_ACM_SCRIPT_URL')) {
	define('ADSIMPLE_ACM_SCRIPT_URL', Uri::root(true) . '/modules/mod_adsimple_acm/media/js/adsimple_cookie_cached.js');
}
// Load document and settings
$doc       = Factory::getApplication()->getDocument();

$settings  = ModAdsimpleAcmHelper::getSettings($params);

/**
 * Fetch remote content using Joomla HTTP client or cURL fallback.
 *
 * @param string $url
 * @param int    $timeout
 * @return string|false
 */

// --- Cache setup ---
$cacheEnabled = !empty($settings['cache_enabled']);
$cacheDir     = JPATH_ROOT . '/modules/mod_adsimple_acm/media/js/';
$cacheFile    = $cacheDir . 'adsimple_cookie_cached.js';

// Default cache period (7 days)
$cacheValue  = isset($settings['cache_period_value']) ? (int)$settings['cache_period_value'] : 7;
$cacheType   = isset($settings['cache_period_type']) ? $settings['cache_period_type'] : 'DAY_IN_SECONDS';
$cookie_list = isset($settings['cookie_list']) ? (int)$settings['cookie_list'] : 0;

switch ($cacheType) {
	case 'MINUTE_IN_SECONDS':
		$cacheSeconds = $cacheValue * 60;
		break;
	case 'HOUR_IN_SECONDS':
		$cacheSeconds = $cacheValue * 3600;
		break;
	default:
		$cacheSeconds = $cacheValue * 86400; // Days
		break;
}

// --- Handle caching and script loading ---
if (!empty($settings['acm_id'])) {
	
	$acm_id        = trim($settings['acm_id']); // Clean up the input 
	$scriptUrl     = ModAdsimpleAcmHelper::getScriptUrlFromAdsimple($acm_id);

	if (!is_array($scriptUrl) || empty($scriptUrl['notice'])) {
		Factory::getApplication()->enqueueMessage(
			Text::_('MOD_ADSIMPLE_ACM_ERROR_FETCH_SCRIPT'),
			'error'
		);
		return;
	}

	$listScriptUrl = $scriptUrl['notic_list'] ?? '';
	$scriptUrl     = $scriptUrl['notice'];

	if ($cacheEnabled) {

		// Check cache age
		$refresh = true;
		if (file_exists($cacheFile)) {
			$fileAgeSeconds = time() - filemtime($cacheFile);
			if ($fileAgeSeconds < $cacheSeconds) {
				$refresh = false;
			}
		}

		// Refresh if needed
		if ($refresh) {
			// Normalize protocol-relative URLs by prefixing https.
			if (strpos($scriptUrl, '//') === 0) {
				$scriptUrl = 'https:' . $scriptUrl;
			}
			
			$remoteContent = ModAdsimpleAcmHelper::FetchContent( $scriptUrl, 12 );  
			
			if ($remoteContent !== false) {
				if ( ! is_dir($cacheDir) ) {
					mkdir($cacheDir, 0755, true);
				}
				
				if (file_exists($cacheFile) && !@unlink($cacheFile) ) {
					Factory::getApplication()->enqueueMessage(
						Text::_('MOD_ADSIMPLE_ACM_ERROR_PURGE_CACHE'),
						'warning'
					);
				}

				File::write($cacheFile, $remoteContent);
			
			} else {
				Factory::getApplication()->enqueueMessage(
					Text::_('MOD_ADSIMPLE_ACM_WARNING_CACHE_REFRESH_FAILED'),
					'warning'
				);
			}
		}

		// Load cached script if available
		if (file_exists($cacheFile)) {
			if(!$cookie_list){
				echo '<script type="text/javascript" src="'.ADSIMPLE_ACM_SCRIPT_URL.'"></script>';
			}
		} else {
			// Fallback to remote script
			if(!$cookie_list){
				echo '<script type="text/javascript" src="'.$scriptUrl.'"></script>';
			}
		}

	} else {
		// Caching disabled: load directly
		if(!$cookie_list){
			echo '<script type="text/javascript" src="'.$scriptUrl.'"></script>';
		}
	}
}
if($cookie_list){
echo '<script type="text/javascript" src="'.$listScriptUrl.'"></script>';    
echo '<div class="js-acm-cookie-list"></div>';
}
?>